/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: CifxConsole_nxDrvAPI.cpp 12620 2018-10-30 11:55:55Z LuisContreras $:

  Description:
    Test nxDrv API functions

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2018-10-19  Ported from cifXTest_Console V1.0.6.0
    2018-09-11  initial version

**************************************************************************************/
#include "OS_Includes.h"
#include "CifXConsole.h"
#include "netXAPI.h"

/*****************************************************************************/
/*! Test NXDrv functions to download a firmware
 *  \param  hDevice  Device handle (unused)
 *  \return True on success                                                  */
/*****************************************************************************/
bool nxDrvAPI( HANDLE hDevice)
{
  NXDRV_DEVICE_INFORMATION tInfo = {0};
  uint32_t ulCmd        = NXDRV_FIND_FIRST;
  uint32_t ulSearchIdx  = 0;
  int32_t  lRet         = 0;

  nxDrvInit();

  do
  {
    ulSearchIdx = 0;

    lRet = nxDrvFindDevice( ulCmd, sizeof(tInfo), &tInfo, &ulSearchIdx);
    if( NXAPI_NO_ERROR != lRet)
    {
      /* Read driver error description */
      ShowError( lRet);
    }else
    {
      /* We found a hardware */
      break;
    }

  }while ( NXAPI_NO_ERROR == lRet);

  if( NXAPI_NO_ERROR == lRet)
  {
    /*-----------------*/
    /* Load a firmware */
    /*-----------------*/
    char* pszFileName = "D:\\Temp\\C0201020.nxf";
    HANDLE hFile = CreateFile(pszFileName,
                              GENERIC_READ,
                              FILE_SHARE_READ,
                              NULL,
                              OPEN_EXISTING,
                              0,
                              NULL);
    if ( hFile == INVALID_HANDLE_VALUE)
    {
      /* Error opening the file */
      printf("NXDrvAPI: Error opening file <%s>, LastError: %d\r\n", pszFileName, GetLastError());
    } else
    {
      DWORD dwFileSize = GetFileSize(hFile, NULL);
      unsigned char* pabFileData = new unsigned char[dwFileSize];

      DWORD dwBytesRead = 0;
      if ( ReadFile(hFile, pabFileData, dwFileSize, &dwBytesRead, NULL) == false)
      {
        /* Error reading the file */
        printf("NXDrvAPI: Error reading file <%s>, LastError: %d\r\n", pszFileName, GetLastError());
      } else
      {
        lRet = nxDrvDownload( tInfo.hDevice, 0, NXAPI_CMD_FIRMWARE, dwFileSize, pszFileName, pabFileData, NULL, NULL);
        if( NXAPI_NO_ERROR != lRet)
        {
          /* Read driver error description */
          ShowError( lRet);
        }else
        {
          /* Start the device */
          lRet = nxDrvStart( tInfo.hDevice, 0);
          if( NXAPI_NO_ERROR != lRet)
          {
            /* Read driver error description */
            ShowError( lRet);
          }
        }
      }

      delete [] pabFileData;
    }
  }

  nxDrvExit();

  return true;
}

/*****************************************************************************/
/*! Entry function for tests on NXAPI                                        */
/*****************************************************************************/
void Test_netXDrvApi( void)
{
  printf("\n--- Test the netX driver API ---\r\n");

  /* Test configuration download */
  nxDrvAPI( NULL);

  printf("\n Test the netX driver API done\r\n");
}
